//---------------------------------------------------------------------------

#include <vcl.h>
#include "Message_Form.h"
#pragma hdrstop
//---------------------------------------------------------------------------
USEFORM("main.cpp", Main_form);
USEFORM("CommControl_Form.cpp", CommControlForm);
USEFORM("Message_Form.cpp", MessageForm);
USEFORM("USBMessage_Form.cpp", USBMessageForm);
USEFORM("OptionSetting_Form.cpp", OptionSettingForm);
//---------------------------------------------------------------------------
WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
{
  const char mutexname[] = "favimstart";
  HANDLE hMutex = NULL;

  hMutex = OpenMutexA(SYNCHRONIZE, false, mutexname);
  if (hMutex==NULL)
  {
    hMutex = CreateMutexA(NULL, true, mutexname);
  }
  else
  {
    CloseHandle(hMutex);
    ShowMessageFA("The program is already running.");
    return 0;
  }

	try
	{
		Application->Initialize();
		Application->CreateForm(__classid(TMain_form), &Main_form);
		Application->CreateForm(__classid(TCommControlForm), &CommControlForm);
		Application->CreateForm(__classid(TUSBMessageForm), &USBMessageForm);
		Application->Run();
	}
	catch (Exception &exception)
	{
		Application->ShowException(&exception);
	}
	catch (...)
	{
		try
		{
			throw Exception("");
		}
		catch (Exception &exception)
		{
			Application->ShowException(&exception);
		}
	}
	return 0;
}
//---------------------------------------------------------------------------













